% -------------------------------
% Segnale a gradini tipo "cella 1 / cella 2 / cella 3"
% Ampiezza ±3 V
% -------------------------------

clear; clc; close all;

fs = 10000;                    % Frequenza di campionamento (puoi alzarla o abbassarla)
T  = 10;                       % Durata totale del segnale in secondi
t  = 0 : 1/fs : T-1/fs;         % Vettore tempo

% Parametri di ogni "cella" (puoi regolare i tempi come vuoi)
t1_start = 0.5;    t1_end = 3.0;
t2_start = 3.2;    t2_end = 5.8;
t3_start = 6.0;    t3_end = 8.6;
t_final  = 9.0;    % punto in cui torna a zero alla fine

% Inizializzo il segnale a zero
segnale = zeros(size(t));

% Costruisco i gradini (ogni cella è un livello piatto)
segnale(t >= t1_start & t < t1_end)   = -3;   % parte bassa cella 1
segnale(t >= t1_end   & t < t2_start) =  0;   % gradino intermedio
segnale(t >= t2_start & t < t2_end)   = +3;   % parte alta cella 2
segnale(t >= t2_end   & t < t3_start) =  0;   % ritorno a zero
segnale(t >= t3_start & t <= t_final) = -3;   % cella 3 bassa
segnale(t > t_final)                  =  0;   % fine

% -------------------------------
% Plot bello come nella tua foto
% -------------------------------
figure('Color','w');
plot(t, segnale, 'r-', 'LineWidth', 2.5);
grid on;
axis([0 T -3.5 3.5]);
set(gca, 'YTick', -3:1:3);
set(gca, 'XTick', 0:0.5:T);
xlabel('Tempo [s]');
ylabel('Ampiezza [V]');
title('Segnale a gradini tipo "cella 1 - cella 2 - cella 3"  (±3 V)');

% (Opzionale) salva come .wav se vuoi mandarlo a un generatore di forme d'onda
% audiowrite('cella123_pm3V.wav', segnale/3, fs);   % normalizzato ±1 per l'audio

% (Opzionale) ascolta (suona come una scala di toni molto bassa)
% sound(segnale/3, fs);